% Returns the transfer matrix for scatters and waveguide

function [mat] = transfer_matrix(r, t, type, varargin)

if strcmp(type, 'usual')==1
    mat = [[1/conj(t), -conj(r)/conj(t)]; [-r/t, 1/t]];
elseif strcmp(type, 'mirror')==1
    mat = [[1/conj(t), r/t]; [conj(r)/conj(t), 1/t]];
elseif strcmp(type, 'waveguide')==1 && nargin==4
    beta = varargin{1};
    mat = [[exp(1i*beta), 0]; [0, exp(-1i*beta)]];
end

end